using UnityEngine;

public class CameraController : MonoBehaviour
{
    public PlayerMovement player;
    public float horizontalSmoothTime = 0.3f;
    public float verticalSmoothTime = 0.5f;
    public float minYPosition = 0f;

    private Vector3 currentVelocity;

    private void Start()
    {
        player = FindObjectOfType<PlayerMovement>();
    }

    private void FixedUpdate()
    {
        Vector3 targetPosition = new Vector3(player.transform.position.x, player.transform.position.y, transform.position.z);

        if (targetPosition.y < minYPosition)
        {
            targetPosition.y = minYPosition;
        }

        Vector3 smoothedPosition = Vector3.SmoothDamp(transform.position, targetPosition, ref currentVelocity, GetSmoothTime());
        transform.position = smoothedPosition;
    }

    private float GetSmoothTime()
    {
        if (!player.isGrounded)
        {
            return verticalSmoothTime;
        }
        return horizontalSmoothTime;
    }
}
