using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class PlayerStats : MonoBehaviour
{

    [SerializeField] private TMP_Text cashText;

    public int cash = 0;


    [SerializeField] int maxAmmo = 5;
    public int currentAmmo;

    [SerializeField] AmmoUI ammoUI;

    private void Start()
    {
        currentAmmo = maxAmmo;
        ammoUI.GenerateAmmo(maxAmmo);
        cashText.text = cash.ToString();
    }

    public void IncreaseCash(int amount)
    {
        cash += amount;
        cashText.text = cash.ToString();
    }

    public void DecreaseCash(int amount)
    {
        cash -= amount;
        cashText.text = cash.ToString();
    }

    public void IncreaseMaxAmmo(int amount)
    {
        maxAmmo += amount;
        ammoUI.AddAmmo();
    }

    public void ReloadAmmo()
    {
        currentAmmo = maxAmmo;
        Debug.Log("Reloaded!");
        ammoUI.ReloadAmmo(maxAmmo);
    }

    public void UseAmmo()
    {
        currentAmmo--;
        ammoUI.UseAmmo();
    }

}
