using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class MusicChanger : MonoBehaviour
{
    public List<AudioClip> musicClips;
    private int currentClipIndex = 0;
    AudioSource audioSource;

    private bool inRange = false;

    private void Start()
    {
        audioSource = GetComponent<AudioSource>();
        if (audioSource != null)
        {
            audioSource.clip = musicClips[currentClipIndex];
            audioSource.Play();
        }
    }

    private void Update()
    {
        if (inRange && Input.GetKeyDown(KeyCode.E))
        {
            NextSong();
        }
    }

    private void OnTriggerEnter2D(Collider2D other)
    {
        if (other.CompareTag("Player"))
        {
            inRange = true;
            string currentSongName = audioSource.clip.name;
            PromptShower.instance.ShowPrompt("Currently Playing: " + currentSongName + ". Press E to change the music!");
        }
    }

    private void OnTriggerExit2D(Collider2D other)
    {
        if (other.CompareTag("Player"))
        {
            inRange = false;
            PromptShower.instance.HidePrompt();
        }
    }

    private void NextSong()
    {
        currentClipIndex = (currentClipIndex + 1) % musicClips.Count;
        audioSource.clip = musicClips[currentClipIndex];
        string currentSongName = audioSource.clip.name;
        PromptShower.instance.ShowPrompt("Currently Playing: " + currentSongName + ". Press E to change the music!");
        audioSource.Play();
    }
}
