using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class HealthPickup : MonoBehaviour
{
    public int healthAmount = 1;

    public bool increaseMaxHealth = false;

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (collision.CompareTag("Player"))
        {
            PlayerHealth playerHealth = collision.GetComponent<PlayerHealth>();
            if (increaseMaxHealth)
            {
                playerHealth.IncreaseMaxHealth(healthAmount);
            }
            else
            {
                playerHealth.Heal(healthAmount);
            }
            Destroy(gameObject);
        }
    }
}
