using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class Destructible : MonoBehaviour
{
    public List<Sprite> hitSprites;
    private SpriteRenderer spriteRenderer;
    private int currentHitIndex = 0;

    public GameObject lootPrefab;

    void Start()
    {
        spriteRenderer = GetComponent<SpriteRenderer>();
        if (hitSprites == null || hitSprites.Count == 0)
        {
            Debug.LogError("No hit sprites assigned.");
        }
        else
        {
            spriteRenderer.sprite = hitSprites[currentHitIndex];
        }
    }

    public void OnHit()
    {
        Debug.Log("Hit!");
        currentHitIndex++;

        if (currentHitIndex < hitSprites.Count)
        {
            spriteRenderer.sprite = hitSprites[currentHitIndex];
        }
        else
        {
            DropLoot();
            Destroy(gameObject);
        }
    }

    private void DropLoot()
    {
        if (lootPrefab != null)
        {
            Instantiate(lootPrefab, transform.position, Quaternion.identity);
        }
    }
}
