using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class CartShadowEnabler : MonoBehaviour
{
    [SerializeField] private Sprite cartShadow;
    [SerializeField] private Sprite cartShown;
    [SerializeField] private SpriteRenderer cartShadowRenderer;

    [SerializeField] SpawnRoomInCart spawnRoomInCart;

    bool isDisabled = false;

    private void Start()
    {
        EnableShadow();
    }

    public void EnableShadow()
    {
        cartShadowRenderer.sprite = cartShadow;
    }

    public void DisableShadow()
    {
        cartShadowRenderer.sprite = cartShown;
        spawnRoomInCart.SpawnRoom();
        isDisabled = true;

    }

    private void OnTriggerEnter2D(Collider2D other)
    {
        if (other.CompareTag("Player") && !isDisabled)
        {
            DisableShadow();
        }
    }
}
