using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class AmmoUI : MonoBehaviour
{
    [SerializeField] GameObject ammoObject;
    [SerializeField] Transform ammoClip;

    public void GenerateAmmo(int ammoAmount)
    {
        for (int i = 0; i < ammoAmount; i++)
        {
            Instantiate(ammoObject, ammoClip);
        }
    }

    public void RemoveAmmo()
    {
        if (ammoClip.childCount > 0)
        {
            Destroy(ammoClip.GetChild(0).gameObject);
        }
    }

    public void RemoveAllAmmo()
    {
        foreach (Transform ammo in ammoClip)
        {
            Destroy(ammo.gameObject);
        }
    }

    public void ReloadAmmo(int ammoAmount)
    {
        RemoveAllAmmo();
        GenerateAmmo(ammoAmount);
    }

    public void UseAmmo()
    {
        RemoveAmmo();
    }

    public void AddAmmo()
    {
        Instantiate(ammoObject, ammoClip);

    }
}
