using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class AmmoPickup : MonoBehaviour
{
    public int ammoAmount = 1;

    public bool IncreaseMaxAmmo = false;

    private void OnTriggerEnter2D(Collider2D collision)
    {
        if (collision.CompareTag("Player"))
        {
            PlayerStats playerStats = collision.GetComponent<PlayerStats>();
            if (IncreaseMaxAmmo)
            {
                playerStats.IncreaseMaxAmmo(ammoAmount);
            }
            else
            {
                playerStats.ReloadAmmo();
            }

            Destroy(gameObject);
        }
    }
}
